-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema pruebas
--

-- CREATE DATABASE IF NOT EXISTS pruebas;
-- USE pruebas;



--
-- Definition of table `s2_manufacturer`
--

DROP TABLE IF EXISTS `s2_manufacturer`;
CREATE TABLE `s2_manufacturer` (
  `id_s2_manufacturer` int(11) NOT NULL AUTO_INCREMENT,
  `codeManufacturer` varchar(40) NOT NULL,
  `description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_s2_manufacturer`),
  UNIQUE KEY `code_UNIQUE` (`codeManufacturer`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `s2_manufacturer`
--

/*!40000 ALTER TABLE `s2_manufacturer` DISABLE KEYS */;
INSERT INTO `s2_manufacturer` (`id_s2_manufacturer`,`codeManufacturer`,`description`) VALUES 
 (1,'Opel',''),
 (2,'Renault',''),
 (3,'Dacia','');
/*!40000 ALTER TABLE `s2_manufacturer` ENABLE KEYS */;


--
-- Definition of table `s2_model`
--

DROP TABLE IF EXISTS `s2_model`;
CREATE TABLE `s2_model` (
  `id_s2_model` int(11) NOT NULL AUTO_INCREMENT,
  `s2_manufacturer_id` int(11) NOT NULL,
  `codeModel` varchar(40) NOT NULL,
  `description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_s2_model`),
  UNIQUE KEY `iu1_s2_model` (`s2_manufacturer_id`,`codeModel`) USING BTREE,
  KEY `fk_s2_model_s2_manufacturer_idx` (`s2_manufacturer_id`),
  CONSTRAINT `fk_s2_model_s2_manufacturer` FOREIGN KEY (`s2_manufacturer_id`) REFERENCES `s2_manufacturer` (`id_s2_manufacturer`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `s2_model`
--

/*!40000 ALTER TABLE `s2_model` DISABLE KEYS */;
INSERT INTO `s2_model` (`id_s2_model`,`s2_manufacturer_id`,`codeModel`,`description`) VALUES 
 (1,3,'Sprint',''),
 (2,3,'Sandero',''),
 (3,2,'Megane',''),
 (4,2,'Clio',''),
 (5,1,'Insignia',''),
 (6,1,'Corsa','');
/*!40000 ALTER TABLE `s2_model` ENABLE KEYS */;

--
-- Definition of table `s2_engine`
--

DROP TABLE IF EXISTS `s2_engine`;
CREATE TABLE `s2_engine` (
  `id_s2_engine` int(11) NOT NULL AUTO_INCREMENT,
  `s2_model_id` int(11) NOT NULL,
  `codeEngine` varchar(40) NOT NULL,
  `description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_s2_engine`),
  UNIQUE KEY `iu1_s2_engine` (`s2_model_id`,`codeEngine`) USING BTREE,
  KEY `fk_s2_engine_s2_model1_idx` (`s2_model_id`),
  CONSTRAINT `fk_s2_engine_s2_model1` FOREIGN KEY (`s2_model_id`) REFERENCES `s2_model` (`id_s2_model`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `s2_engine`
--

/*!40000 ALTER TABLE `s2_engine` DISABLE KEYS */;
INSERT INTO `s2_engine` (`id_s2_engine`,`s2_model_id`,`codeEngine`,`description`) VALUES 
 (1,1,'electric120Cv 200Km',''),
 (2,2,'GLP 1.2 60CV',''),
 (3,2,'gasoline 1.2 65CV',''),
 (4,3,'gasoline 1.0 120CV',''),
 (5,5,'gasoline 2.0 180CV',''),
 (6,3,'electric 150CV 300Km',''),
 (7,5,'diesel 1.6 150CV',''),
 (8,6,'electric 150CV 250Km',''),
 (9,6,'gasoline 1.0 100CV',''),
 (10,4,'diesel 1.5 105CV',''),
 (11,4,'gasoline 1.2 65CV','');
/*!40000 ALTER TABLE `s2_engine` ENABLE KEYS */;



--
-- Definition of table `s2_order`
--

DROP TABLE IF EXISTS `s2_order`;
CREATE TABLE `s2_order` (
  `id_s2_order` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `s2_manufacturer_id` int(11) NOT NULL,
  `s2_model_id` int(11) NOT NULL,
  `s2_engine_id` int(11) NOT NULL,
  PRIMARY KEY (`id_s2_order`),
  KEY `fk_s2_order_s2_manufacturer1_idx` (`s2_manufacturer_id`),
  KEY `fk_s2_order_s2_model1_idx` (`s2_model_id`),
  KEY `fk_s2_order_s2_engine1_idx` (`s2_engine_id`),
  CONSTRAINT `fk_s2_order_s2_engine1` FOREIGN KEY (`s2_engine_id`) REFERENCES `s2_engine` (`id_s2_engine`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_s2_order_s2_manufacturer1` FOREIGN KEY (`s2_manufacturer_id`) REFERENCES `s2_manufacturer` (`id_s2_manufacturer`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_s2_order_s2_model1` FOREIGN KEY (`s2_model_id`) REFERENCES `s2_model` (`id_s2_model`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `s2_order`
--

/*!40000 ALTER TABLE `s2_order` DISABLE KEYS */;
INSERT INTO `s2_order` (`id_s2_order`,`name`,`s2_manufacturer_id`,`s2_model_id`,`s2_engine_id`) VALUES 
 (1,'Fernando',3,1,1),
 (2,'Fernando',2,3,4),
 (3,'Fernando',2,4,11),
 (4,'Fernando',1,5,5);
/*!40000 ALTER TABLE `s2_order` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
